//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "ServerForm.h"
//---------------------------------------------------------------------------
#pragma link "Shell_DDE"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{

}

//---------------------------------------------------------------------------
/***************************************************************************************
  Object:   TForm1
  Function: IsBusy

  Comments: Always returns false - but your program may need to determine whether it
            can deal with the command or needs to start another session or allow user
            to cancel

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************/
bool __fastcall TForm1::IsBusy()

{ return false; }

//---------------------------------------------------------------------------
/***************************************************************************************
  Object:   TForm1
  Function: ShellCommandInterfaceCommandSwitch

  Comments: This event is triggered for every command line switch -e.g. '/register'
            or '-unregister'

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************/
void __fastcall TForm1::ShellCommandInterfaceCommandSwitch(AnsiString Switch)
{ // register the file association details
  if (Switch.LowerCase() == "register") {
    ShellCommandInterface->RegisterFileAssociations(False);
    MessageBoxA(Handle, "File Ext Registered", "Register", MB_ICONINFORMATION);
  };
  // unregister the file association details
  if (Switch.LowerCase() == "unregister") {
    ShellCommandInterface->UnRegisterFileAssociations();
    MessageBoxA(Handle, "File Ext Unregistered", "Register", MB_ICONINFORMATION);
  };
}
//---------------------------------------------------------------------------
/***************************************************************************************
  Object:      TForm1
  Constructor: Create

  Comments:    Set up the instructions at the top of the form

  Version:   1.00
  Date last Modified: 28 May 2000
****************************************************************************************/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  LblRegister->Caption= ParamStr(0) + " /register";
  lblUnRegister->Caption= ParamStr(0) + " /unregister";
  lblTestFile->Caption= ExtractFilePath(ParamStr(0)) + "Test.Test";
}
//---------------------------------------------------------------------------
/***************************************************************************************
  Object:   TForm1
  Function: FormResize

  Comments: When the form is resize change the memo height as appropriate

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************/

void __fastcall TForm1::FormResize(TObject *Sender)
{
  Memo1->Height = ClientHeight - 100;
}
//---------------------------------------------------------------------------


/***************************************************************************************
  Object:   TForm1
  Function: ShellCommandInterfaceCustomDefaultCommand

  Comments: This is the event triggered when a "Custom Command" is recieved.
            If the standard commands are recieved but have no assigned event
            then this event will be triggered

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************/
void __fastcall TForm1::ShellCommandInterfaceCmdCustom(AnsiString Command,
	AnsiString FileName, AnsiString Option)
{
  if (IsBusy()) {
    // Put functionality (if required) to handle when busy.
  }
  else {
    // Display time, command, filename and options passed
    Memo1->Lines->Add("*************");
    Memo1->Lines->Add(FormatDateTime("hh:nn:ss", Now()));
    Memo1->Lines->Add("Command - " + Command);
    Memo1->Lines->Add("Filename - " + FileName);
    Memo1->Lines->Add("Options - " + Option);
  }
}
//---------------------------------------------------------------------------
/***************************************************************************************
  Object:   TForm1
  Function: ShellCommandInterfaceOpenFile

  Comments: This is the event triggered when the user selects Open or double clicks
            on a file in explorer.  If this event is deleted then the actions will go
            to ShellCommandInterfaceCustomDefaultCommand

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************/
void __fastcall TForm1::ShellCommandInterfaceCmdOpenFile(AnsiString FileName,
	AnsiString Option)
{
  if (IsBusy()) {
    // Put functionality (if required) to handle when busy.
  }
  else {
    // Display time, command, filename and options passed
    Memo1->Lines->Add("*************");
    Memo1->Lines->Add(FormatDateTime("hh:nn:ss", Now()));
    Memo1->Lines->Add("Open File");
    Memo1->Lines->Add("Filename - " + FileName);
    Memo1->Lines->Add("Options - " + Option);
  }
}
//---------------------------------------------------------------------------
